import java.net.InetAddress;
import cnrg.itx.datax.devices.*;
import cnrg.itx.datax.PropertiesCollection;
import java.net.UnknownHostException;

public class VirtualNetworkSource extends NullSource
{
	private String m_ip;
	private int m_port;
	private int m_sampleSize;
	
	public VirtualNetworkSource(String ip, int port, int sampleSize) {
		m_ip = ip;
		m_port = port;
		m_sampleSize = sampleSize;
	}
	
	public PropertiesCollection getProperties() {
		PropertiesCollection pc = new PropertiesCollection();
		try {
			pc.addProperty(new NetworkProperty(m_port, InetAddress.getByName(m_ip),
											   m_sampleSize, 0, -1));
			return pc;
		} catch (UnknownHostException e) {
			return null;
		}
	}
}
